output "service_status" {
  value       = kubernetes_service.app.status
  description = "The K8S Service status"
}

locals {
  status = kubernetes_service.app.status
}

output "service_endpoint" {
  value = try(
    "http://${local.status[0]["load_balancer"][0]["ingress"][0]["hostname"]}",
    "(error parsing hostname from status)"
  )
  description = "Punkt końcowy K8S Service"
}
